function guiSliderPlot
% guiSliderPlot has a slider
% It plots sin(x) from 0 to the value of the slider
% Format: guisliderPlot
  
f = figure('Visible', 'off', 'Units', 'Normalized',...
    'Position', [.2 .5 .4 .3], 'Color', 'white');
 
% Minimum and maximum values for slider
minval = 0;
maxval = 4*pi;
 
% Create the slider object
slhan = uicontrol('Style','slider','Units','Normalized',...
    'Position',[.3 .7 .4 .1], ...
    'Min', minval, 'Max', maxval,'Callback', @callbackfn);
% Text boxes to show the min and max values and slider value
hmintext = uicontrol('Style','text','BackgroundColor', 'white', ...
    'Units','Normalized','Position', [.1 .7 .1 .1],...
    'String', num2str(minval));
hmaxtext = uicontrol('Style','text', 'BackgroundColor', 'white',...
    'Units', 'Normalized','Position', [.8 .7 .1 .1], ...
    'String', num2str(maxval));
hsttext = uicontrol('Style','text','BackgroundColor', 'white',...
    'Units','Normalized', 'Position', [.45 .8 .1 .1],...
    'Visible','off');
% Create axes handle for plot
axhan = axes('Position', [.2 .1 .6 .5]);
 
f.Name = 'Slider Example with sin plot';
movegui(f,'center')
f.Visible = 'on';
 
% Call back function displays the current slider value & plots sin
   function callbackfn(~,~)
       % callbackfn is called by the 'Callback' property
       % in the slider
       num = slhan.Value;
       set(hsttext,'Visible','on','String',num2str(num))
       x = 0:num/50:num;
       y = sin(x);
       plot(x,y)
       xlabel('x')
       ylabel('sin(x)')
    end
end
